<?php

require_once(getcwd().'/sys/module/kicomoco_admin/controller/requireadmin.php');
require_once(getcwd().'/sys/module/kicomoco/model/testimonial.php');
require_once(getcwd().'/sys/module/kicomoco/model/testimonial_category.php');

class Kicomoco_Admin_Controller_Testimonials extends Kicomoco_Admin_Controller_Requireadmin {
	
	public function listAction() {
	
		$testimonial = new Kicomoco_Model_Testimonial($this->_mysqli);
		$category = new Kicomoco_Model_Testimonial_Category($this->_mysqli);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/testimonials/list.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Testimonials',
				'testimonials'=>$testimonial,
				'categories'=>$category
			)
		);
		
		return $return;
		
	}
	
	public function newAction() {
	
		$testimonial = new Kicomoco_Model_Testimonial($this->_mysqli);

		if (count($_POST)>0) {
			
			$testimonial->strTitle = $_POST['strTitle'];
			$testimonial->strContent = $_POST['strContent'];
			$testimonial->strCategory = (isset($_POST['strCategory']) && strlen(trim($_POST['strCategory']))>0 ? $_POST['strCategory'] : null);
			$testimonial->bolShowOnHomepage = (isset($_POST['bolShowOnHomepage']) ? $_POST['bolShowOnHomepage'] : 0);
			
			$testimonial->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = "uploads/".$testimonial->makeSafeFilename("testimonial-{$testimonial->intId}-{$testimonial->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strImage']['tmp_name'], $newName);
				
				$testimonial->strImage = $newName;
				$testimonial->save();
				
			}
			
			$this->_redirect(SYS_PATH.'admin/testimonials');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/testimonials/edit.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Testimonial',
				'testimonial'=>$testimonial,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editAction() {
		
		$testimonial = new Kicomoco_Model_Testimonial($this->_mysqli);
		
		$testimonial->load($_GET['testimonial']);
		
		if (count($_POST)>0) {
		
			$testimonial->strTitle = $_POST['strTitle'];
			$testimonial->strContent = $_POST['strContent'];
			$testimonial->strCategory = (isset($_POST['strCategory']) && strlen(trim($_POST['strCategory']))>0 ? $_POST['strCategory'] : null);
			$testimonial->bolShowOnHomepage = (isset($_POST['bolShowOnHomepage']) ? $_POST['bolShowOnHomepage'] : 0);

			$testimonial->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = "uploads/".$testimonial->makeSafeFilename("testimonial-{$testimonial->intId}-{$testimonial->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strImage']['tmp_name'], $newName);
				
				$testimonial->strImage = $newName;
				$testimonial->save();
				
			}
						
			$this->_redirect(SYS_PATH.'admin/testimonials');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/testimonials/edit.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Testimonial',
				'testimonial'=>$testimonial,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
	public function newcategoryAction() {
	
		$category = new Kicomoco_Model_Testimonial_Category($this->_mysqli);

		if (count($_POST)>0) {
			
			$category->strCategory = $_POST['strCategory'];
			$category->save();
			
			$this->_redirect(SYS_PATH.'admin/testimonials#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/testimonials/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Testimonial Category',
				'category'=>$category,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editcategoryAction() {
		
		$category = new Kicomoco_Model_Testimonial_Category($this->_mysqli);
		
		$category->load($_GET['category']);
		
		if (count($_POST)>0) {
		
			$category->strCategory = $_POST['strCategory'];
			$category->save();
			
			$this->_redirect(SYS_PATH.'admin/testimonials#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/testimonials/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Testimonial Category',
				'category'=>$category,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
}