<?php

require_once(getcwd().'/sys/module/kicomoco_admin/controller/requireadmin.php');
require_once(getcwd().'/sys/module/kicomoco/model/news.php');
require_once(getcwd().'/sys/module/kicomoco/model/news_category.php');
require_once(getcwd().'/sys/module/kicomoco/model/rewrite.php');

class Kicomoco_Admin_Controller_News extends Kicomoco_Admin_Controller_Requireadmin {
	
	public function listAction() {
	
		$news = new Kicomoco_Model_News($this->_mysqli);
		$categories = new Kicomoco_Model_News_Category($this->_mysqli);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/news/list.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > News Articles',
				'newss'=>$news,
				'categories'=>$categories
			)
		);
		
		return $return;
		
	}
	
	public function deletecategoryAction() {
		
		$category = new Kicomoco_Model_News_Category($this->_mysqli);
		$category->load($_GET['category']);
		$category->bolDeleted=1;
		$category->save();
		
		$this->_redirect($_SERVER['HTTP_REFERER']);
		
	}
	
	public function newAction() {
	
		$news = new Kicomoco_Model_News($this->_mysqli);

		if (count($_POST)>0) {
			
			$news->strTitle = $_POST['strTitle'];
			$news->strContent = $_POST['strContent'];
			$news->strCategory = $_POST['strCategory'];
			$news->strUrl = $news->generateUrl();

			$news->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = "uploads/".$news->makeSafeFilename("news-{$news->intId}-{$news->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strImage']['tmp_name'], $newName);
				
				$news->strImage = $newName;
				$news->save();
				
			}
			
			$newargs = serialize(array('intId'=>$news->intId));
			
			$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
			$rewrite->strUrl = $news->strUrl;
			$rewrite->strModule = 'kicomoco';
			$rewrite->strController = 'news';
			$rewrite->strAction = 'article';
			$rewrite->strArgs = $newargs;
			$rewrite->save();
			
			$this->_redirect(SYS_PATH.'admin/news');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/news/edit.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New News Article',
				'news'=>$news,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editAction() {
		
		$news = new Kicomoco_Model_News($this->_mysqli);
		
		$news->load($_GET['article']);
		
		if (count($_POST)>0) {
		
			$news->strTitle = $_POST['strTitle'];
			$news->strContent = $_POST['strContent'];
			$news->strCategory = $_POST['strCategory'];
			$news->strUrl = $news->generateUrl();

			$news->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = 'uploads/'.$news->makeSafeFilename("{$news->intId}-{$news->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strImage']['tmp_name'], $newName);
				
				$news->strImage = $newName;
				$news->save();
				
			}
			
			$newargs = serialize(array('intId'=>$news->intId));
			
			$rewrites = new Kicomoco_Model_Rewrite($this->_mysqli);
			
			$rewrites->where('strModule','kicomoco')
				->where('strController','news')
				->where('strAction','article')
				->where('strArgs',$newargs);
				
			if ($rewrites->count()>0) {
				
				$rewrite = $rewrites->fetch();
				$rewrite->strUrl = $news->strUrl;
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			} else {
				
				// No rewrite, lets create it!
				$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
				$rewrite->strUrl = $page->strUrl;
				$rewrite->strModule = 'kicomoco';
				$rewrite->strController = 'news';
				$rewrite->strAction = 'article';
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			}
			
			$this->_redirect(SYS_PATH.'admin/news');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/news/edit.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit News Article',
				'news'=>$news,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
	public function newcategoryAction() {
	
		$category = new Kicomoco_Model_News_Category($this->_mysqli);

		if (count($_POST)>0) {
			
			$category->strCategory = $_POST['strCategory'];
			$category->save();
			
			$this->_redirect(SYS_PATH.'admin/news#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/news/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New News Category',
				'category'=>$category,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editcategoryAction() {
		
		$category = new Kicomoco_Model_News_Category($this->_mysqli);
		
		$category->load($_GET['category']);
		
		if (count($_POST)>0) {
		
			$category->strCategory = $_POST['strCategory'];
			$category->save();
			
			$this->_redirect(SYS_PATH.'admin/news#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/news/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit News Category',
				'category'=>$category,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
}