<?php

require_once(getcwd().'/sys/module/kicomoco/model/abstract.php');

class Kicomoco_Model_Table extends Kicomoco_Model_Abstract {
	
	public $_table = '';
	public $_primaryKey = '';
	public $_where = array();
	public $_orWhere = array();
	public $_customWhere = array();
	public $_group = array();
	public $_order = array();
    public $_data = array();
    public $_origData = array();
    public $_results = null;
    public $_limit1 = null;
    public $_limit2 = null;
	public $_sql = null;
	public $_columns = array();
	public $_iterator = 0;
	public $_bolWhere = false;
	public $_autoInsertField = null;
	
	public function setColumns(array $columns) {
		
		$this->_columns = $columns;
		
	}

	public function addColumn(string $column) {
		
		$this->_columns[] = $column;
		
	}

	public function resetColumns() {
		
		$this->_columns = array();
		
	}
	
	public function __construct(&$mysqli) {
		
		parent::__construct($mysqli);
		
	}

	public function getId() {
	
		if (isset($this->_data[$this->_primaryKey])) return $this->_data[$this->_primaryKey];
		
		return null;
		
	}

	public function reload() {

		if (!is_null($this->{$this->_primaryKey})) {
				
			$primaryKeyVal = $this->{$this->_primaryKey};
			$this->reset();
			$this->load($primaryKeyVal);
				
		}
			
		return $this;
	
	}

	public function reset() {
		
		$this->_where = array();
		$this->_orWhere = array();
		$this->_customWhere = array();
		$this->_group = array();
		$this->_order = array();
		$this->_data = array();
		$this->_origData = array();
		$this->_sql = '';
		$this->_results = null;
		$this->_limit1 = null;
		$this->_limit2 = null;
		$this->_columns = array();
		$this->_iterator = 0;
		$this->_bolWhere = false;

		return $this;
		
	}

	public function resetWhere() {
		
		$this->_where = array();
		$this->_orWhere = array();
		$this->_customWhere = array();
		$this->_group = array();
		$this->_order = array();
		$this->_bolWhere = false;

		return $this;
		
	}

    public function load($primaryKey) {

        $this->reset();

        $this->where($this->_primaryKey,$primaryKey);

        $this->exec();

        //if (count($this->_results)>0) {
		if ($this->_results->num_rows>0) {
	        //$this->_data = array_shift($this->_results);
			$this->_data = $this->_results->fetch_assoc();
	        $this->_origData = $this->_data;
	        $this->_results = array($this->_data);
        }

        return $this;

    }
	
    public function __set($name, $value) {

        $this->_data[$name] = $value;
        return $this;

    }

    public function __get($name) {

        if (isset($this->_data[$name])) return $this->_data[$name];

        return null;

    }

    public function __isset($name) {

        return isset($this->_data[$name]);

    }
    
    public function group($strGroup) {
    
    		$this->_group[] = $strGroup;
    		$this->_select = null;
    		return $this;
    
    }

    public function where($strWhere, $value=null) {

        $this->_where[] = array('strWhere'=>$strWhere,'value'=>$value);
        $this->_select = null;
        return $this;

    }
    
    public function orWhere($strWhere, $value=null) {
    
    		$this->_orWhere[] = array('strWhere'=>$strWhere,'value'=>$value);
    		$this->_select = null;
    		return $this;
    
    }
    
    public function customWhere($strWhere, $value=null) {
	    
	    $this->_customWhere[] = array('strWhere'=>$strWhere,'value'=>$value);
	    $this->_select = null;
	    return $this;
	    
    }

    public function order($strOrder) {

        $this->_order[] = $strOrder;
        $this->_select = null;
        return $this;

    }

    public function buildSelect() {
        
        //$this->_select = $this->_mysqli->select()->from($this->_table);
		$this->_sql = 'SELECT ';
		
		if (count($this->_columns)==0) $this->_sql .= '*';
		else $this->_sql .= implode(',',$this->_columns);
	
		$this->_sql .= " FROM {$this->_table}";

        if (count($this->_where)>0) {
            foreach ($this->_where as $where) {
				if ($this->_bolWhere) $this->_sql .= ' AND ';
				else $this->_sql .= ' WHERE ';
                if (isset($where['value']) && !is_null($where['value'])) { //!==NULL) {
                    //$this->_select->where($where['strWhere'],$where['value']);
					//$this->_sql .= ' AND ' . $this->_mysqli->quoteInto("{$where['strWhere']} = ?", $where['value']);

					$this->_sql .= "{$where['strWhere']} = '".$this->_mysqli->real_escape_string($where['value'])."'";
                } else {
                    //$this->_select->where($where['strWhere']);
					$this->_sql .= $where['strWhere'];
                }
				$this->_bolWhere = true;
            }
        }
        
        if (count($this->_orWhere)>0) {
            foreach ($this->_orWhere as $where) {
            		if ($this->_bolWhere) $this->_sql .= ' OR ';
				else $this->_sql .= ' WHERE ';
				if (isset($where['value']) && !is_null($where['value'])) { //!==NULL) {
                    //$this->_select->orWhere($where['strWhere'],$where['value']);
					//$this->_sql .= ' OR ' . $this->_mysqli->quoteInto("{$where['strWhere']} = ?", $where['value']);
					$this->_sql .= "{$where['strWhere']} = '".$this->_mysqli->real_escape_string($where['value'])."'";
                } else {
                    //$this->_select->orWhere($where['strWhere']);
					$this->_sql .= $where['strWhere'];
                }
				$this->_bolWhere = true;
            }
        }
        
        if (count($this->_customWhere)>0) {
	        foreach ($this->_customWhere as $where) {
		        if ($this->_bolWhere) $this->_sql .= ' AND ';
		        else $this->_sql .= ' WHERE ';
		        if (isset($where['value']) && !is_null($where['value'])) {
			        $this->_sql .= str_replace('?',"'".$this->_mysqli->real_escape_string($where['value'])."'",$where['strWhere']);
		        }
		        $this->_bolWhere = true;
	        }
        }
        
        if (count($this->_group)>0) {
       		//foreach ($this->_group as $group) {
        			//$this->_select->group($group);
				$this->_sql .= ' GROUP BY ' . implode(',',$this->_group);
        		//}
        }
		
		if (count($this->_order)>0) {
			//foreach ($this->_order as $order) {
				//$this->_select->order($order);	
				$this->_sql .= ' ORDER BY ' . implode(',',$this->_order);
			//}
		}
		
		if ($this->_limit1 && $this->_limit2) $this->_sql .= " LIMIT {$this->_limit1}, {$this->_limit2}"; //$this->_select->limit($this->_limit1, $this->_limit2);
		elseif ($this->_limit1) $this->_sql .= " LIMIT {$this->_limit1}"; //$this->_select->limit($this->_limit1);
   
    }
    
    public function assemble() {
    
    		$this->buildSelect();
    	
    		//$assemble = $this->_select->assemble();
    	
    		//$this->_select = null;
    	
    		return $this->_sql; //$assemble;
    
    }

    public function exec() {

        $this->_results = array();
        
        $this->buildSelect();

        //$stmt = $this->_select->query();

		$this->_results = $this->_mysqli->query($this->_sql);
		
		if ($this->_mysqli->errno) {
			
			throw new Exception("{$this->_mysqli->errno}: {$this->_mysqli->error}");
			
		}

        //$this->_results = $stmt->fetchAll();

        return $this;

    }

    public function fetch($index = null) {

        if (!$this->_sql) {

            $this->exec();

        }

		if (!$index) {
			$index = $this->_iterator;
			$this->_iterator++;
		}

        if ($this->count()>$index) {

            $record = clone $this;

            $record->resetWhere();
            $record->_data = $this->_results->fetch_assoc(); //array_shift($this->_results);
            $record->_origData = $record->_data;

            $record->where("{$this->_primaryKey}",$record->_data[$record->_primaryKey]);

            return $record;

        } else {

			$this->_select = null;
            return null;

        }

    }

    public function count() {

        if (!$this->_sql) {

            $this->exec();

        }

        return $this->_results->num_rows;

    }
    
    public function fetchAll() {
    
    		//return $this->_results->fetch_all(MYSQLI_ASSOC);

		$collection = array();
		
		while ($object = $this->fetch()) $collection[] = $object;
			
		return $collection;
    
    }

    public function save() {
 
    		$bolChanged = false;
    		$arrChangedFields = array();
		$arrChangedVals = array();
		
		foreach ($this->_data as $key=>$val) {
        		
			$oldVal = NULL;
        		if (isset($this->_origData[$key])) $oldVal = $this->_origData[$key];
        	
			if (
        			(!is_null($oldVal) && !is_null($val) && $oldVal<>$val)
        			|| (is_null($oldVal) && !is_null($val))
        			|| (!is_null($oldVal) && is_null($val))) {
        			$bolChanged = true;
        			$arrChangedFields[] = $key;
				if (is_null($val)) $arrChangedVals[$key] = null;
				else $arrChangedVals[$key] = $this->_mysqli->real_escape_string($val);
        		}
        }
    
        if ($bolChanged) {
	
	        if (count($this->_where)>0 || count($this->_customWhere)>0) {
	            // Update
	            
	            $strWhere = '';
	            
	            if (count($this->_where)>0) {
		            foreach ($this->_where as $where) {
		                if (isset($where['value']) && !is_null($where['value'])) {
		                		if (strlen($strWhere)>0) $strWhere .= ' AND ';
		                		$strWhere .= str_replace('?',"'".$this->_mysqli->real_escape_string($where['value'])."'",$where['strWhere'].'=?');
		                } else {
		                    if (strlen($strWhere)>0) $strWhere .= ' AND ';
		                		$strWhere .= $where['strWhere'];
		                }
		            }
	            }
	            
		        if (count($this->_customWhere)>0) {
			        foreach ($this->_customWhere as $where) {
				        if ($this->_bolWhere) $strWhere .= ' AND ';
				        else $strWhere .= ' WHERE ';
				        if (isset($where['value']) && !is_null($where['value'])) {
					        $strWhere .= str_replace('?',$this->_mysqli->real_escape_string($where['value']),$where['strWhere']);
				        }
			        }
		        }

	            $dataToSave = array();

	            $sql = "UPDATE {$this->_table} SET ";
	            foreach ($arrChangedVals as $key=>$val) {
		            if (is_null($val)) $sql .= "`{$key}`=NULL,";
		            else $sql .= str_replace('?',"'{$val}'","`{$key}`=?,");
	            }
	            $sql = substr($sql, 0, -1)." WHERE {$strWhere}";

	            $this->_mysqli->query($sql);
	            
	        } else {
	        
	            // Insert
	            //$this->_mysqli->insert($this->_table,$this->_data);
				$sql = "INSERT INTO {$this->_table} (`".implode('`,`',$arrChangedFields)."`) VALUES ('".implode('\',\'',$arrChangedVals)."')";
				$this->_mysqli->query($sql);
				
				if (!is_null($this->_autoInsertField)) $this->{$this->_autoInsertField} = $this->_mysqli->insert_id;
		
        	}

			$this->reload();
        
        }
   
        return $this;

    }
    
    public function limit($num, $num2=null) {
    
    		$this->_limit1 = $num;
    		$this->_limit2 = $num2;
        $this->_select = null;
    	
    		return $this;
    
    }

    public function delete() {

        $strWhere = '';

        if (count($this->_where)>0) {
	        foreach ($this->_where as $where) {
	            if (isset($where['value']) && !is_null($where['value'])) {
	                $strWhere .= ' AND '.str_replace('?',"'{$where['value']}'",$where['strWhere'].'=?');
	            } else {
	                $strWhere .= ' AND '.$where['strWhere'];
	            }
	        }
        }

        if (count($this->_customWhere)>0) {
	        foreach ($this->_customWhere as $where) {
		        if ($this->_bolWhere) $this->_sql .= ' AND ';
		        else $this->_sql .= ' WHERE ';
		        if (isset($where['value']) && !is_null($where['value'])) {
			        $this->_sql .= str_replace('?',$this->_mysqli->real_escape_string($where['value']),$where['strWhere']);
		        }
	        }
        }

		$this->_mysqli->query("DELETE FROM `{$this->_table}` WHERE ".substr($strWhere, 5));
		//this->_mysqli->delete($this->_table, substr($strWhere, 5));

        return $this;

    }

}