<?php

define('FPDF_FONTPATH',getcwd().'/sys/module/thirdparty/fpdf_font');

require_once(getcwd().'/sys/module/thirdparty/lib/fpdf.php');
require_once(getcwd().'/sys/module/thirdparty/lib/fpdi.php');
require_once(getcwd().'/sys/module/kicomoco/model/barcodeCalc.php');

$path = get_include_path();
$newPath = $path.PATH_SEPARATOR.getcwd().'/sys/module/thirdparty/lib';
set_include_path($newPath);

class kicomoco_model_pdf extends FPDI {
	
	public $_debug = false;
	public $angle=0;
	
	function Code128($string,$x,$y,$w=1,$h=1) {
	
		if ($this->_debug) echo '<pre>Barcode: '.$string."\n";
		
		$barcodeCalc = new Kicomoco_Model_BarcodeCalc();
		$barcode = $barcodeCalc->Code128($string);
		
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(0,0,0);
		
		// We need to find how wide the barcode is...to half it and remove from X! So that we are centering it on the position...
		$barcodeWidth = 0;
		for ($i=0;$i<strlen($barcode);$i++) {
			$barwidth = substr($barcode,$i,1);
			$barcodeWidth += ($w/10)*$barwidth;
		}
		$x -= $barcodeWidth/2;
		
		for ($i=0;$i<strlen($barcode);$i++) {
			$barwidth = substr($barcode,$i,1);
			$width = ($w/10)*$barwidth;
			if ($i%2==0) $this->Rect($x,$y,$width,$h,'F');			
			$x += $width;
		}
		
		//die;
		if ($this->_debug) die;
		
	}
	
	function Rotate($angle,$x=-1,$y=-1) {
	    if($x==-1)
	        $x=$this->x;
	    if($y==-1)
	        $y=$this->y;
	    if($this->angle!=0)
	        $this->_out('Q');
	    $this->angle=$angle;
	    if($angle!=0)
	    {
	        $angle*=M_PI/180;
	        $c=cos($angle);
	        $s=sin($angle);
	        $cx=$x*$this->k;
	        $cy=($this->h-$y)*$this->k;
	        $this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm 1 0 0 1 %.2F %.2F cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
	    }
	}
	
	function _endpage() {
	    if($this->angle!=0)
	    {
	        $this->angle=0;
	        $this->_out('Q');
	    }
	    parent::_endpage();
	}	
	
}