<?php

require_once(getcwd().'/sys/module/kicomoco/model/table.php');

class Kicomoco_Model_Email extends Kicomoco_Model_Table {
	
	public $_table = 'tbl_email_queue';
	public $_primaryKey = 'intId';
	public $_autoInsertField = 'intId';
	
	public function renderFromTemplate($template, $data, $fromEmail, $fromName, $toEmail, $toName, $subject) {
		
		global $smarty;
		
		foreach ($data as $key=>$val) $smarty->assign($key,$val);
		
		$html = $smarty->fetch($template);
		
		$this->sendHtml($fromEmail, $fromName, $toEmail, $toName, $subject, $html);
		
	}
	
	public function sendHtml($fromEmail, $fromName, $toEmail, $toName, $subject, $html) {
		
		$sql = 'INSERT INTO tbl_email_queue (`strFromEmail`,`strFromName`,`strToEmail`,`strToName`,`strSubject`,`strHtml`)
			VALUES (?,?,?,?,?,?)';
			
		$stmt = $this->_mysqli->prepare($sql);
		
		if ($stmt) {

			$stmt->bind_param('ssssss',$fromEmail,$fromName,$toEmail,$toName,$subject,$html);
			$stmt->execute();

		} else {

			throw new MySQLException('Unable to prepare SQL: '.$sql);

		}
		
	}
	
	public function sendPlain($fromEmail, $fromName, $toEmail, $toName, $subject, $message) {
		
		$sql = 'INSERT INTO tbl_email_queue (`strFromEmail`,`strFromName`,`strToEmail`,`strToName`,`strSubject`,`strMessage`)
			VALUES (?,?,?,?,?,?)';

		$stmt = $this->_mysqli->prepare($sql);

		if ($stmt) {

			$stmt->bind_param('ssssss',$fromEmail,$fromName,$toEmail,$toName,$subject,$message);
			$stmt->execute();

		} else {

			throw new MySQLException('Unable to prepare SQL: '.$sql);

		}
		
	}
	
	public function cron() {
		
		$this->where('bolSent=0');
		
		while ($email = $this->fetch()) {
			
			// Send the email
			
			$headers = '';
			$headers .='Return-Path: <'.$email->strFromEmail.'>'."\r\n";
			
			if ($email->strFromName) $headers .= 'From: '.$email->strFromName.' <'.$email->strFromEmail.'>'."\r\n";
			else $headers .= 'From: '.$email->strFromEmail."\r\n";
			
			if ($email->strToName) $headers .= 'To: '.$email->strToName.' <'.$email->strToEmail.'>'."\r\n";
			else $headers .= 'To: '.$email->strToEmail."\r\n";
					
			$headers .= 'MIME-Version: 1.0'."\r\n";
			
			if (!is_null($email->strMessage)) {
			
				$headers .= 'Content-Type: text/plain; charset=utf8'."\r\n".
					'Content-Transfer-Encoding: quoted-printable'."\r\n";
				
				$content = $this->qp_encoding($email->strMessage);
			
			} elseif (!is_null($email->strHtml)) {
				
				$headers .= 'Content-Type: text/html; charset=utf8'."\r\n".
							'Content-Transfer-Encoding: quoted-printable'."\r\n";
				
				$content = $this->qp_encoding($email->strHtml);
				
			}
			
			$args = '-f '.$email->strFromEmail;
			
			mail('', $email->strSubject, $content, $headers, $args);			
			
			$email->bolSent = 1;
			$email->save();
			
		}
		
	}
	
	private function qp_encoding($Message) { 
    
	    for ($i=0; $i<127; $i++) { 
	        $CharList[$i] = "/".chr($i+128)."/"; 
	        $HexList[$i] = "=".strtoupper(bin2hex(chr($i+128))); 
	    } 
	
	    $Message = str_replace("=", "=3D", $Message); 
	    $Message = preg_replace($CharList, $HexList, $Message); 
	
	    $MessageLines = explode("\n", $Message); 
	    $Message_qp = ""; 
	    
	    while(list(, $Line) = each($MessageLines)) { 
	    
	        if (strlen($Line) > 75) { 
	        
	            $Pointer = 0;   
	                 
	            while ($Pointer <= strlen($Line)) { 
	            
	                $Offset = 0; 
	                if (preg_match("/^=(3D|([8-9A-F]{1}[0-9A-F]{1}))$/", substr($Line, ($Pointer+73), 3))) $Offset=-2; 
	                if (preg_match("/^=(3D|([8-9A-F]{1}[0-9A-F]{1}))$/", substr($Line, ($Pointer+74), 3))) $Offset=-1; 
	                $Message_qp.= substr($Line, $Pointer, (75+$Offset))."=\n"; 
	                
	                if ((strlen($Line) - ($Pointer+75)) <= 75) {   
	                             
	                    $Message_qp.= substr($Line, ($Pointer+75+$Offset))."\n"; 
	                    break 1; 
	                    
	                } 
	                
	                $Pointer+= 75+$Offset; 
	                
	            } 
	            
	        } else { 
	        
	            $Message_qp.= $Line."\n"; 
	            
	        } 
	        
	    }       
	     
	    return $Message_qp; 
	} 

}