<?php

require_once(getcwd().'/sys/module/kicomoco/controller/abstract.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_category.php');
require_once(getcwd().'/sys/module/kicomoco/model/product.php');

class Kicomoco_Controller_Ecommerce extends Kicomoco_Controller_Abstract {
	
	public function categoryAction($args) {
		
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);
		
		$category->load($args['strCategory']);
		
		if ($category->getProducts()->where('bolDeleted=0')->count()==1 && $category->bolAlternativeListing==0) {
			
			// Only one product....redirect to it!
			$product = $category->getProducts()->fetch();
			$this->_redirect(SYS_PATH.$product->strUrl);
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'public/layout.tpl',
			'template'=>'public/ecommerce/category.tpl',
			'args'=>array(
				'title'=>'Haygain - Equine Hay Steamers | '.$category->strCategory,
				'category'=>$category,
				'categories'=>new Kicomoco_Model_Product_Category($this->_mysqli)
			)
		);
		
		return $return;

	}
	
	public function productAction($args) {
		
		$product = new Kicomoco_Model_Product($this->_mysqli);
		
		$product->load($args['intProduct']);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'public/layout.tpl',
			'template'=>'public/ecommerce/product.tpl',
			'args'=>array(
				'title'=>'Haygain - Equine Hay Steamers | '.$product->strTitle,
				'product'=>$product,
				'categories'=>new Kicomoco_Model_Product_Category($this->_mysqli)
			)
		);
		
		return $return;
		
	}

}