<?php

class Kicomoco_Controller_Abstract {
	
	public $_mysqli;
	public $_smarty;
	public $_controller;
	public $_action;
	public $_bodyclasses = array();
	
	public function makeNiceUrl($string) {
		
		$allowedCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-";
		
		$newString = '';
		
		for($i=0;$i<strlen($string);$i++) {
			
			$char = substr($string,$i,1);
			if (strpos($allowedCharacters,$char)===FALSE) $newString .= '-';
			else $newString .= $char;
			
		}
		
		while (strpos($newString,'--')!==FALSE) $newString = str_replace('--','-',$newString);
		
		return $newString;
		
	}

	public function __construct(&$mysqli, &$smarty, &$controller, &$action) {

		$this->_mysqli = $mysqli;
		$this->_smarty = $smarty;
		$this->_controller = $controller;
		$this->_action = $action;
		
		$this->_bodyclasses[] = $controller;
		$this->_bodyclasses[] = $action;

	}

	public function requiresSession() {

		if (session_id()=='') session_start();

	}

	public function addSuccess($strMessage) {
		
		$this->addMessage('success',$strMessage);
		
	}

	public function addWarning($strMessage) {
		
		$this->addMessage('warning',$strMessage);
		
	}

	public function addError($strMessage) {
		
		$this->addMessage('error',$strMessage);
		
	}
	
	public function addBodyClass($class) {
		
		if (is_array($class)) {
			foreach ($class as $clas) $this->_bodyclasses[] = $clas;
		} else {
			$this->_bodyclasses[] = $class;
		}
		
	}

	public function addMessage($strType, $strMessage) {
		
		if (!isset($_SESSION['messages'])
			|| !is_array($_SESSION['messages'])) $_SESSION['messages'] = array();
		
		if (!isset($_SESSION['messages'][$strType])
			|| !is_array($_SESSION['messages'][$strType])) $_SESSION['messages'][$strType] = array();
			
		$_SESSION['messages'][$strType][] = $strMessage;
		
	}

	public function getMessages() {

		if (!isset($_SESSION['messages'])
			|| !is_array($_SESSION['messages'])) $_SESSION['messages'] = array();
		
		$messages = $_SESSION['messages'];
		
		$_SESSION['messages'] = array();
		
		return $messages;
		
	}

	public function fetchBasics() {
		
		return array(
			'strUrl'=>$_SERVER['REQUEST_URI'],
			'messages'=>$this->getMessages(),
			'bodyclasses'=>$this->_bodyclasses
		);
	
	}

	public function _redirect($strUrl) {
		
		Header("Location: {$strUrl}");
		exit;
		
	}

	public function _forward($moduleName, $controllerName, $actionName, $args = array()) {

		$controllerFile = getcwd()."/sys/module/{$moduleName}/controller/{$controllerName}.php";

		if (file_exists($controllerFile) && is_file($controllerFile)) {
			$controllerClass = "{$moduleName}_Controller_{$controllerName}";
			require_once($controllerFile);
			$controller = new $controllerClass($this->_mysqli, $this->_smarty, $controllerName, $actionName);
		} else {
			throw new InvalidControllerException("Invalid controller (Module: {$moduleName}, Controller: {$controllerName})");
		}

		$actionMethod = $actionName.'Action';

		if (method_exists($controller,$actionMethod)) {
			$actionResults = $controller->$actionMethod($args);
		} else {
			throw new InvalidActionException("Invalid action (Module: {$moduleName}, Controller: {$controllerName}, Action: {$actionName}");
		}

		$this->_smarty->assign('basics',$actionResults['basics']);

		foreach ($actionResults['args'] as $key=>$val) $this->_smarty->assign($key,$val);

		$this->_smarty->assign('template',"{$moduleName}/{$controllerName}/{$actionResults['template']}");

		$this->_smarty->display($actionResults['layout']);

		exit;

	}
	
	public function arrayInject($array, $key, $val) {
		
		foreach ($val as $arrayitem) {
			$array[$key][]=$arrayitem;
		}
		return $array;
		
	}

}