<?
	
include("header.php");

require_once('config/path.php');
require_once('config/db.php');
require_once('sys/init.php');

require_once('sys/module/kicomoco/model/news.php');

$news = new Kicomoco_Model_News($mysqli);

$news->order('dteStamp DESC');

if (isset($_GET['category'])) $news->where('strCategory',$_GET['category']);

?>
   
<div class="container">  
<div class="row">
<hr class="light">
<div class="col-xs-12 col-md-8 col-lg-8 news-page"> 
<h5>News</h5>


<?php
	
foreach ($news->fetchAll() as $article) {
	
	?>
	
	<div style="clear: both">
	<a href="<?php echo SYS_PATH.$article->strUrl; ?>"><img src="<?php echo SYS_PATH.$article->strImage; ?>" width="154" border="0"></a>
	<h6><?php echo $article->strTitle; ?></h6>
	<?php echo trim(substr(str_replace("\n","<br>\n",$article->strContent),0,200)); ?>...
	<br>
	<br>
	
	<a href="<?php echo SYS_PATH.$article->strUrl; ?>">&gt; read more</a>
	<br>
	<br>
	<br>
	</div>
	
	<?php
	
}	
	
?>

</div>

<div class="col-xs-12 col-md-4 col-lg-4">



<div class="box">
	<h5>Categories</h5><br />
	<ul>
		<?php
		foreach ($news->getAvailableCategories()->where('bolDeleted=0')->fetchAll() as $category) {
		?>
			<li><a href="news.php?category=<?php echo urlencode($category->strCategory); ?>"><?php echo $category->strCategory; ?></a></li>
	  	<?php
	  	}
	  	?>
  	</ul>
</div>





<div class="box"> 
<h5>Shows & Events</h5>
Visit the HAYGAIN stand at:
<br>
<br>
<strong>14th - 22nd March
</strong><br>
Equitana trade show
<br>
<br>
<strong>8th - 12th April </strong><br>
Winter Show Jumping Championships, Hartpury Arena in Gloucestershire
<br>
<br>
<strong>15th - 19th April</strong><br>
Winter Dressage Championships, Hartpury Arena in Gloucestershire
<br>
<br>
<strong>6th - 10th May </strong><br>
Badminton Horse Trials, Gloucestershire
<br>
<br>
<strong>11th -14th June</strong><br>
Bramham Horse Trials, Yorkshire
<br>
<br>
<strong>9th -12th July </strong><br>
Barbury Horse Trials, Wiltshire
<br>
<br>
<strong>3rd - 6th September </strong><br>
Burghley Horse Trials, Lincolnshire
<br>
<br>
<strong>10th - 13th September </strong><br>
Blair Castle HorseTrials, Perthshire
<br>
<br>
<strong>17th - 20th September </strong><br>
  British Dressage National Championships, Stoneleigh Park in Warwickshire

</div>
</div>

</div>
</div>
<?php include("footer.php"); ?>