<?
	
include("header.php");

require_once('config/path.php');
require_once('config/db.php');
require_once('sys/init.php');

require_once('sys/module/kicomoco/model/product.php');
require_once('sys/module/kicomoco/model/product_category.php');

$products = new Kicomoco_Model_Product($mysqli);
$categories = new Kicomoco_Model_Product_Category($mysqli);

?>
   
<div class="container">  
<div class="row">
<hr class="light">
<div class="col-xs-12 col-md-12 col-lg-12">
<h5>buy Now</h5>
<?php
foreach ($products->where('bolDeleted=0')->where('bolShowOnBuyNowPage=1')->fetchAll() as $product) {
	?><a href="buy_now.php#product-<?php echo $product->intId; ?>"><?php echo $product->strTitle; ?></a>&nbsp;&nbsp;&nbsp;&nbsp;<?php	
}
foreach ($categories->where('bolDeleted=0')->where('bolShowOnBuyNowPage=1')->order('intOrder')->fetchAll() as $category) {
	?><a href="buy_now.php#category-<?php echo urlencode($category->strCategory); ?>"><?php echo $category->strCategory; ?></a>&nbsp;&nbsp;&nbsp;&nbsp;<?php	
}
?>
<br>
<br>
</div>
</div>


<?php
foreach ($products->reset()->where('bolDeleted=0')->where('bolShowOnBuyNowPage=1')->fetchAll() as $product) {
	?>
	<div class="row">
		<div class="col-xs-12 col-md-6 col-lg-6 padding-right">
			<a name="<?php echo 'product-'.$product->intId; ?>"></a>
			<div id="myCarousel1" class="carousel slide" data-ride="carousel">
				<div class="carousel-inner" role="listbox">
					<?php
					foreach ($product->getImages()->order('intOrder')->where('bolDeleted=0')->fetchAll() as $index=>$image) {
						?><div class="item<?php if ($index==0) { echo ' active'; } ?>"><img src="<?php echo SYS_PATH.$image->strImage; ?>" alt=""></div><?php
					}	
					?>
				</div>
				<?php
				if ($product->getImages()->count()>1) {
					?>	
					<a class="left carousel-control" href="#myCarousel1" role="button" data-slide="prev">
						<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
						<span class="sr-only">Previous</span>
					</a>
					<a class="right carousel-control" href="#myCarousel1" role="button" data-slide="next">
						<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
						<span class="sr-only">Next</span>
					</a>
					<?php
					}
				?>
			</div>
			<br>
		</div>
	
		<div class="col-xs-12 col-md-6 col-lg-6">
			<?php
			if ($product->strPayPalBIN) {
				echo $product->strPayPalBIN;
			}
			?>
			<h5><?php echo $product->strTitle; ?></h5> 
			<?php if ($product->strShortDescription) { echo $product->strShortDescription; } ?>
			<div class="panel-group" id="accordion-<?php echo $product->intId; ?>" role="tablist" aria-multiselectable="true" style="clear: both">
			  	<?php if ($product->strFeatures) { ?>
			  	<div class="panel panel-default">
			    	<div class="panel-heading" role="tab" id="headingOne">
						<h4 class="panel-title">
							<a class="collapsed" data-toggle="collapse" data-parent="#accordion-<?php echo $product->intId; ?>" href="#collapse1-<?php echo $product->intId; ?>" aria-expanded="false" aria-controls="collapse1-<?php echo $product->intId; ?>">Features <span class="glyphicon glyphicon-plus"></span></a>
			      		</h4>
			    	</div>
					<div id="collapse1-<?php echo $product->intId; ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
						<div class="panel-body">
							<?php echo $product->strFeatures; ?>
			      		</div>
			    	</div>
			  	</div>
			  	<?php } ?>
			  	<?php if ($product->strDetailsCare) { ?>
			  	<div class="panel panel-default">
			    	<div class="panel-heading" role="tab" id="headingTwo">
						<h4 class="panel-title">
							<a class="collapsed" data-toggle="collapse" data-parent="#accordion-<?php echo $product->intId; ?>" href="#collapse2-<?php echo $product->intId; ?>" aria-expanded="false" aria-controls="collapse2-<?php echo $product->intId; ?>">Details & Care <span class="glyphicon glyphicon-plus"></span></a>
			      		</h4>
			    	</div>
					<div id="collapse2-<?php echo $product->intId; ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
						<div class="panel-body">
							<?php echo $product->strDetailsCare; ?>
						</div>
	    			</div>
	  			</div>
	  			<?php } ?>
	  			<?php if ($product->strDelivery) { ?>
	  			<div class="panel panel-default">
	  				<div class="panel-heading" role="tab" id="headingThree">
	  					<h4 class="panel-title">
	  						<a class="collapsed" data-toggle="collapse" data-parent="#accordion-<?php echo $product->intId; ?>" href="#collapse3-<?php echo $product->intId; ?>" aria-expanded="false" aria-controls="collapse3-<?php echo $product->intId; ?>">Delivery <span class="glyphicon glyphicon-plus"></span></a>
	  					</h4>
	  				</div>
	  				<div id="collapse3-<?php echo $product->intId; ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingThree">
	  					<div class="panel-body">
		  					<?php echo $product->strDelivery; ?>
		  				</div>
		  			</div>
		  		</div>
		  		<?php } ?>
		  		<?php if ($product->strSize) { ?>
		  		<div class="panel panel-default">
		  			<div class="panel-heading" role="tab" id="headingFour">
		  				<h4 class="panel-title">
		  					<a class="collapsed" data-toggle="collapse" data-parent="#accordion-<?php echo $product->intId; ?>" href="#collapse4-<?php echo $product->intId; ?>" aria-expanded="false" aria-controls="collapse4-<?php echo $product->intId; ?>">Size <span class="glyphicon glyphicon-plus"></span></a>
		  				</h4>
		  			</div>
		  			<div id="collapse4-<?php echo $product->intId; ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingFour">
		  				<div class="panel-body">
		  					<?php echo $product->strSize; ?>
		  				</div>
		  			</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</div>
	<?php
}	
foreach ($categories->reset()->where('bolDeleted=0')->where('bolShowOnBuyNowPage=1')->order('intOrder')->fetchAll() as $category) {
	?>
	<div class="row">
		<div class="col-xs-12 col-md-6 col-lg-6 padding-right">
			<a name="<?php echo 'category-'.urlencode($category->strCategory); ?>"></a>
			<div id="myCarousel1" class="carousel slide" data-ride="carousel">
				<div class="carousel-inner" role="listbox">
					<div class="item active"><img src="<?php echo SYS_PATH.$category->strCategoryImage; ?>" alt=""></div>
				</div>
			</div>
			<br>
		</div>
	
		<div class="col-xs-12 col-md-6 col-lg-6">
			<h5><?php echo $category->strCategory; ?></h5> 
			<br>
	
			<a href="<?php echo SYS_PATH.$category->strUrl; ?>">&gt; Click here to see the <?php echo $category->strCategory; ?> products.</a>
			<br>
			<br>
			<br>  
			<div class="panel-group" id="accordion-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" role="tablist" aria-multiselectable="true">
			  	<?php if ($category->strFeatures) { ?>
			  	<div class="panel panel-default">
			    	<div class="panel-heading" role="tab" id="headingOne">
						<h4 class="panel-title">
							<a class="collapsed" data-toggle="collapse" data-parent="#accordion-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" href="#collapse1-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" aria-expanded="false" aria-controls="collapse1-category-<?php echo str_replace(' ','-',$category->strCategory); ?>">Features <span class="glyphicon glyphicon-plus"></span></a>
			      		</h4>
			    	</div>
					<div id="collapse1-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
						<div class="panel-body">
							<?php echo $category->strFeatures; ?>
			      		</div>
			    	</div>
			  	</div>
			  	<?php } ?>
	  			<?php if ($category->strDelivery) { ?>
	  			<div class="panel panel-default">
	  				<div class="panel-heading" role="tab" id="headingThree">
	  					<h4 class="panel-title">
	  						<a class="collapsed" data-toggle="collapse" data-parent="#accordion-category-<?php str_replace(' ','-',$category->strCategory); ?>" href="#collapse3-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" aria-expanded="false" aria-controls="collapse3-category-<?php echo str_replace(' ','-',$category->strCategory); ?>">Delivery <span class="glyphicon glyphicon-plus"></span></a>
	  					</h4>
	  				</div>
	  				<div id="collapse3-category-<?php echo str_replace(' ','-',$category->strCategory); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingThree">
	  					<div class="panel-body">
		  					<?php echo $category->strDelivery; ?>
		  				</div>
		  			</div>
		  		</div>
		  		<?php } ?>
			</div>
		</div>
	</div>
	<?php
}	
?>
</div>




</div>


<?php include("footer.php"); ?>